function [x, xNames]=Struct2Vector(S,BuildNames);
%	[x, xNames]=Struct2Vector(S,BuildNames)
%	returns a row vector of the flattened elements of S and
%	(optionally) a cell array of variable names.
Names = fieldnames(S);
x = [];
xNames = {};
if nargin<2
	BuildNames = logical(0);
end
for i=1:length(Names)
	v = Names{i};
	y = getfield(S,v);
	if isstruct(y)
		[z, zNames] = Struct2Vector(y, BuildNames);
		x = [x z];
		if BuildNames
			sNames = strcat(v, '.', zNames);
			xNames = [xNames sNames];
		end
	else
		if length(y)==1	%	scalar
			x = [x y];
			if BuildNames
				xNames = [xNames {v}];
			end
		else
			[m,n] = size(y);
			k = m*n;
			x = [x reshape(y',1,k)];	% y is stored 'by row'
			if BuildNames
				if m==1 | n==1	%vector
					zNames = cell(1,k);
					for i=1:k
						zNames{i} = sprintf('%s(%d)',v,i);
					end
				else	%	matrix
					zNames = cell(m,n);
					for i=1:m
						for j=1:n
							zNames{i,j} = sprintf('%s(%d,%d)',v,i,j);
						end
					end
					zNames = reshape(zNames',1,k);
				end
				xNames = [xNames zNames];
			end
		end
	end
end


